; (*| 19:14 19/08/1990 *)
TITLE	Magnify
PAGE	60,78

WORD_OUTS_OK	equ	1

LF	EQU 0AH
CR	EQU 0DH

CRT_INDEX	EQU 3D4H
CRT_DATA	EQU 3D5H

DOSV_SET_MODE	EQU 0		; Set Current Video Mode
DOSV_SETCURS	EQU 2	 
DOSV_RDCURS	EQU 3	 
DOSV_GET_MODE	EQU 0FH 	; Get Current Video Mode
DOSV_PALETTE	EQU 10H
DOSV_LOAD_FONT	EQU 11H
DOSV_L_F_BLOCK	EQU 03H
DOSV_L_F_RE_CALC EQU 10H
DOSV_L_F_INFO	EQU 30H
DOSV_EGA_MISC	EQU 12H
DOSV_21_UTILS	EQU 21H 	; New functions provided by this TSR

DOSV21_GET_MODE EQU 0
DOSV21_REMOVE	EQU 1
DOSV21_SET_MODE EQU 2
DOSV21_LARGE	EQU 3
DOSV21_NORMAL	EQU 4
DOSV21_ADDRESS	EQU 5
DOSV21_HOT_KEY	EQU 6

DOSF_CONOUT	EQU  2		; Console output
DOSF_OUTSTR	EQU 09H		; Output string
DOSF_SIVEC	EQU 25H		; Set interrupt vector
DOSF_DOSVER	EQU 30H
DOSF_KEEP	EQU 31H 	; Advanced KEEP
DOSF_GETIVEC	EQU 35H 	; Get interrupt vector
DOSF_TERMPROC	EQU 4CH
DOSF_FREEMEM	EQU 49H
DOSF_IN_VARS	EQU 52H

DOSI_KEYACTION	EQU 09H 	; Keyboard action
DOSI_VIDEO	EQU 10H 	; Video interrupt
DOSI_KEYBOARD	EQU 16H 	; Keyboard services
DOSI_TERM	EQU 20H		; Program terminate
DOSI_FUNC	EQU 21H		; Perform a function
DOSI_TERMR	EQU 27H		; Program terminate and stay resident

VECT_TABLE	SEGMENT AT 0
	ORG	24H
INT9VECT	DW	?
INT9VECTCS	DW	?
	ORG	40H
INT10VECT	DW	?
INT10VECTCS	DW	?
VECT_TABLE	ENDS

BIOSDATA	SEGMENT AT 40H
	ORG	10H
EQUIP_FLAG	DW	?
	ORG	17H
KB_FLAG DB	?
	ORG	50H
CURS0_COL	DB	?
CURS0_ROW	DB	?
BIOSDATA	ENDS

OUT_WORD	macro
if WORD_OUTS_OK
	out	dx,ax
else
	out	dx,al
	inc	dx
	xchg	ah,al
	out	dx,al
	dec	dx
	xchg	ah,al
endif
	endm


CONSTANT_TO_INDEXED_REGISTER	macro	ADDRESS, INDEX, VALUE
	mov	dx,ADDRESS
	mov	ax,(VALUE shl 8) + INDEX
	OUT_WORD
	endm

CODE	SEGMENT
	ASSUME	CS:CODE
	ORG	100H
BEGIN:	JMP	START_BACKGROUND

POP_MODE	DB	0
HOT_KEY_MODE	DB	0
HOT_KEY_CHAR	DB	30		; 'A' key
HOT_KEY_MISC	DB	0101B		; Ctrl and Right Shift
WIDTH_NOW	DB	80
HEIGHT_NOW	DB	25
DOUBLE_HEIGHT	DB	0
OLD_MODE	DB	0
ADDRESS_NOW	DW	0
CURSOR_NOW	DW	(?)
PAGE_NOW	DB	(?)
KEYBDVECT	DD	(?)		; old interrupt address
VIDEOVECT	DD	(?)		; old interrupt address

KEYBDINTNEW:
KB	PROC FAR
	STI
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	MOV	AX,CS
	MOV	ES,AX
	MOV	AX,40H
	MOV	DS,AX

	ASSUME	DS:BIOSDATA,ES:CODE
	MOV	DI,OFFSET CODE_TABLE
	MOV	CX,CODE_TABLE_LENGTH
	IN	AL,60H			; Read from keyboard
	CMP	AL,7FH
	JA	NOT_FOR_US_JMP		; Process key release operations
	CLD
	REPNE	SCASB
	JNE	FOR_US
NOT_FOR_US_JMP:
	JMP	NOT_FOR_US
FOR_US:
	CMP	BYTE PTR CS:POP_MODE,0
	JZ	READ_FIRST_KEY
	JMP	WAIT_ESC
READ_FIRST_KEY:
	CMP	BYTE PTR CS:HOT_KEY_MODE,0
	JNE	REDEFINE_HOT_KEY
	CMP	AL,BYTE PTR CS:HOT_KEY_CHAR
	JZ	READ_REST
JMP_NOT_FOR_US:
	JMP	NOT_FOR_US
READ_REST:
	MOV	AL,KB_FLAG
	AND	AL,0FH
	CMP	AL,BYTE PTR CS:HOT_KEY_MISC
	JNZ	JMP_NOT_FOR_US
	MOV	AH,DOSV_GET_MODE
	INT	DOSI_VIDEO
	MOV	CS:OLD_MODE,AL
	AND	AL,7EH
	CMP	AL,2
	JE	CHANGE_MODE
	CMP	BYTE PTR CS:WIDTH_NOW,40
	JNE	POP_END 		; Skip if not 80 col text mode
	JMP	SHORT SET_FLAG

CHANGE_MODE:
	MOV	AX,(DOSV_21_UTILS SHL 8) + DOSV21_LARGE
	INT	DOSI_VIDEO
SET_FLAG:
	MOV	BYTE PTR CS:POP_MODE,0FFH	; Set flag
POP_END:
	IN	AL,61H			; Read keyboard control port
	MOV	AH,AL
	OR	AL,80H
	OUT	61H,AL			; Tell the keyboard OK
	MOV	AL,AH	
	OUT	61H,AL			; Restore old value
	CLI
	MOV	AL,20H			; EOI command
	OUT	20H,AL			; to 8259 
	POP	ES
	POP	DS
	POP	DI	 
	POP	SI	 
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	STI				; enable interrupts
	IRET				; End of interrupt processing

REDEFINE_HOT_KEY:
	MOV	BYTE PTR CS:HOT_KEY_CHAR,AL
	MOV	AL,KB_FLAG
	AND	AL,0FH
	MOV	BYTE PTR CS:HOT_KEY_MISC,AL
	MOV	BYTE PTR CS:HOT_KEY_MODE,0
	JMP	POP_END_JMP

NOT_FOR_US:
	POP	ES
	POP	DS
	POP	DI	 
	POP	SI	 
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	JMP	DWORD PTR CS:KEYBDVECT	; Continue with old interrupt routine

WAIT_ESC:
	CMP	AL,68			; F10
	JZ	QUIT_POPUP
	CMP	AL,71			; Home
	JZ	HOME
	CMP	AL,72			; UpArrow
	JZ	UP
	CMP	AL,73			; PgUp
	CMP	AL,75			; LeftArrow
	JZ	LEFT
	CMP	AL,77			; RightArrow
	JZ	RIGHT
	CMP	AL,80			; DnArrow
	JZ	DOWN
	CMP	AL,81			; PgDn
	CMP	AL,01H			; ESC
	JNZ	POP_END_JMP		; Else ignore key press
	MOV	AX,(DOSV_21_UTILS SHL 8) + DOSV21_NORMAL
	INT	DOSI_VIDEO
QUIT_POPUP:
	MOV	BYTE PTR CS:POP_MODE,0	; Clear flag
POP_END_JMP:
	JMP	POP_END

HOME:
	MOV	WORD PTR CS:ADDRESS_NOW,0
	CALL	ADJUST_ADDRESS
	JMP	POP_END_JMP

RIGHT:
	ADD	WORD PTR CS:ADDRESS_NOW,20
	CALL	ADJUST_ADDRESS
	JMP	POP_END_JMP
	
DOWN:
	ADD	WORD PTR CS:ADDRESS_NOW,80 * 6
	CALL	ADJUST_ADDRESS
	JMP	POP_END_JMP
	
LEFT:
	CMP	WORD PTR CS:ADDRESS_NOW,0
	JE	POP_END_JMP
	SUB	WORD PTR CS:ADDRESS_NOW,20
	CALL	ADJUST_ADDRESS
	JMP	POP_END_JMP
	
UP:
	CMP	WORD PTR CS:ADDRESS_NOW,80 * 6
	JB	POP_END_JMP
	SUB	WORD PTR CS:ADDRESS_NOW,80 * 6
	CALL	ADJUST_ADDRESS
	JMP	POP_END_JMP
	
CODE_TABLE:
	DB	42,54,56,29		; l shift, r shift, Alt, Ctrl
CODE_TABLE_LENGTH	EQU	$-CODE_TABLE

KB	ENDP

ADJUST_ADDRESS	PROC	NEAR
	MOV	CX,CS:ADDRESS_NOW
	MOV	AX,(DOSV_21_UTILS SHL 8) + DOSV21_ADDRESS
	INT	DOSI_VIDEO
	RET
ADJUST_ADDRESS	ENDP

VIDEOINTNEW:
VIDEO	PROC FAR
	CMP	AH,DOSV_21_UTILS
	JE	DO_BW_UTILS
NOT_KNOWN:
	JMP	DWORD PTR CS:VIDEOVECT	; Continue with old interrupt routine

DO_BW_UTILS:
	CMP	AL,MAX_BW_UTIL
	JAE	NOT_KNOWN
;	CLI				; inhibit interrupts
	PUSH	ES
	PUSH	DS
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	CX
	PUSH	BX
	PUSH	AX
	CLD
	CBW
	ADD	AX,AX

	ADD	AX,OFFSET UTILS_TABLE
	MOV	SI,AX
	JMP	CS:[SI]

UTILS_TABLE:
	DW	OFFSET GET_MODE
	DW	OFFSET REMOVE_UTILS
	DW	OFFSET SET_MODE
	DW	OFFSET MAKE_LARGE
	DW	OFFSET MAKE_NORMAL
	DW	OFFSET SET_ADDRESS
	DW	OFFSET HOT_KEY

TABLE_SIZE	EQU	$-UTILS_TABLE
MAX_BW_UTIL	EQU	TABLE_SIZE SHR 1

HOT_KEY:
	MOV	BYTE PTR CS:HOT_KEY_MODE,0FFH
	JMP	DONE_BW_UTILS

;new start address in CX

SET_ADDRESS:
	MOV	DX,CRT_INDEX
	MOV	AL,0DH			; Start Address Low
	MOV	AH,CL
	OUT_WORD
	DEC	AL			; Start Address High
	MOV	AH,CH
	OUT_WORD
	JMP	DONE_BW_UTILS

MAKE_NORMAL:
	MOV	BYTE PTR CS:WIDTH_NOW,80
	MOV	AX,DOSV_LOAD_FONT*256 + DOSV_L_F_BLOCK
	MOV	BL,0000B		; block specifiers
	INT	DOSI_VIDEO 	     ; set diffent block specs
	MOV	AH,DOSV_SET_MODE
	MOV	AL,OLD_MODE
	OR	AL,80H
	INT	DOSI_VIDEO
	MOV	AH,DOSV_SETCURS
	MOV	DX,CS:CURSOR_NOW
	MOV	BH,CS:PAGE_NOW
	INT	DOSI_VIDEO
	JMP	DONE_BW_UTILS

MAKE_LARGE:
	MOV	BYTE PTR CS:WIDTH_NOW,40
	MOV	AH,DOSV_RDCURS
	INT	DOSI_VIDEO
	MOV	CS:CURSOR_NOW,DX
	MOV	CS:PAGE_NOW,BH
	MOV	AH,DOSV_SET_MODE
	MOV	AL,81H			; 40 column mode
	INT	DOSI_VIDEO
	MOV	AH,DOSV_SETCURS
	MOV	DX,CS:CURSOR_NOW
	ADD	DH,DH
	MOV	BH,CS:PAGE_NOW
	INT	DOSI_VIDEO
	CONSTANT_TO_INDEXED_REGISTER	CRT_INDEX,13H,40
	CMP	BYTE PTR CS:DOUBLE_HEIGHT,0
	JE	NOT_DOUBLE
	MOV	AX,DOSV_LOAD_FONT*256 + DOSV_L_F_BLOCK
	MOV	BL,1111B		; block specifiers
	INT	DOSI_VIDEO 	     ; set diffent block specs
	MOV	AX,((28-1) SHL 8) + 9
	OUT_WORD
NOT_DOUBLE:
	JMP	DONE_BW_UTILS

SET_MODE:
	MOV	BYTE PTR CS:DOUBLE_HEIGHT,BH
	JMP	DONE_BW_UTILS

; returns 

GET_MODE:
	POP	AX			; restore save registers
	POP	BX
	POP	CX
	POP	DX
	MOV	AL,BYTE PTR CS:OLD_MODE
	MOV	BL,BYTE PTR CS:HOT_KEY_MODE
	MOV	CX,CS
	MOV	DX,'BW'
	JMP	RETURN_BW_UTILS

REMOVE_UTILS:
	CLI
	PUSH	DS
	SUB	AX,AX
	MOV	DS,AX

	ASSUME	DS:VECT_TABLE

	MOV	AX,WORD PTR CS:KEYBDVECT
	MOV	INT9VECT,AX
	MOV	AX,WORD PTR CS:KEYBDVECT+2
	MOV	INT9VECTCS,AX		; Old vector restored
	MOV	AX,WORD PTR CS:VIDEOVECT
	MOV	INT10VECT,AX
	MOV	AX,WORD PTR CS:VIDEOVECT+2
	MOV	INT10VECTCS,AX		; Old vector restored
	POP	DS
	PUSH	CS
	POP	ES
	MOV	AH,DOSF_FREEMEM
	INT	DOSI_FUNC	; Release memory occupied by this program

;	 JMP	 DONE_BW_UTILS

DONE_BW_UTILS:
	POP	AX
	POP	BX
	POP	CX
	POP	DX
RETURN_BW_UTILS:
	POP	SI
	POP	DI
	POP	DS
	POP	ES
	STI				; enable interrupts
	IRET
VIDEO	ENDP

THIS_SITE	LABEL NEAR
SPAN	EQU	THIS_SITE - BEGIN

IF	SPAN MOD 16
	ORG	(THIS_SITE + 16) - (SPAN MOD 16)
ENDIF

ENV_SEG EQU	WORD PTR BEGIN-0D4H

	ASSUME	CS:CODE,DS:CODE,ES:CODE

START_BACKGROUND:
	CLD
	MOV	DX,OFFSET TITMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	CALL	CHECK_DOS_AND_EGA
	CALL	PROCESS_COMMAND_STRING
	MOV	SI,WORD PTR CS:COMMAND_PTR
	MOV	CX,WORD PTR CS:COMMAND_PTR+2    ; length
	CMP	CX,0
	JZ	NOT_HELP
;	JZ	NO_COMMAND
	CMP	BYTE PTR [SI],'?'
	JNZ	NOT_HELP
NO_COMMAND:
	MOV	DX,OFFSET HLPMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 3
	INT	DOSI_FUNC

NOT_HELP:
	MOV	AX,'/s'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_S_OPTION	    ; option not found
	MOV	BYTE PTR HEIGHT_FLAG,0FFH
	MOV	BYTE PTR HEIGHT_VAL,0
NOT_S_OPTION:
	MOV	AX,'/d'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_D_OPTION	    ; option not found
	CALL	MAKE_DOUBLE_FONT
	MOV	BYTE PTR HEIGHT_FLAG,0FFH
	MOV	BYTE PTR HEIGHT_VAL,1
NOT_D_OPTION:
	MOV	AX,'/k'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_K_OPTION	    ; option not found
	MOV	BYTE PTR HOT_KEY_FLAG,0FFH
NOT_K_OPTION:
	MOV	AX,'/r'
	CALL	SEARCH_FOR_OPTIONS
	JB	NOT_R_OPTION	    ; option not found
	MOV	BYTE PTR REMOVE_FLAG,0FFH
	CALL	EXISTS
	JE	REMOVE_EXISTING
	MOV	DX,OFFSET NOMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 4
	INT	DOSI_FUNC

REMOVE_EXISTING:
	MOV	AH,DOSV_21_UTILS
	MOV	AL,DOSV21_REMOVE
	INT	DOSI_VIDEO
	MOV	AX,3
	INT	DOSI_VIDEO
	MOV	DX,OFFSET REMMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	JMP	EXIT_OK

NOT_R_OPTION:
	CALL	EXISTS
	JE	ALREADY_EXISTS
	JMP	INSTALL
ALREADY_EXISTS:
	CALL	SET_HEIGHT
	CALL	SET_HOT_KEY
EXIT_OK:
	MOV	AX,DOSF_TERMPROC*256 + 0
	INT	DOSI_FUNC

INSTALL:
	MOV	AL,DOSI_KEYACTION
	MOV	DI,OFFSET KEYBDVECT
	MOV	DX,OFFSET KEYBDINTNEW
	CALL	SET_VEC 		; install new serial int vector
	MOV	AL,DOSI_VIDEO
	MOV	DI,OFFSET VIDEOVECT
	MOV	DX,OFFSET VIDEOINTNEW
	CALL	SET_VEC 		; install new serial int vector
	CALL	SET_HEIGHT
	CALL	SET_HOT_KEY
	MOV	DX,OFFSET NEWMSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	ES,ENV_SEG
	MOV	AH,DOSF_FREEMEM 
	INT	DOSI_FUNC
	MOV	DX,OFFSET START_BACKGROUND
;	INT	DOSI_TERMR
	MOV	CL,4
	SHR	DX,CL
	MOV	AH,DOSF_KEEP
	INT	DOSI_FUNC

EXISTS	PROC	NEAR
	MOV	AX,(DOSV_21_UTILS SHL 8) + DOSV21_GET_MODE
	MOV	DX,0
	INT	DOSI_VIDEO
	CMP	DX,'BW' 		; test for installed ID
	RET
EXISTS	ENDP

SET_HEIGHT	PROC	NEAR
	CMP	BYTE PTR HEIGHT_FLAG,0
	JE	NO_SET_HEIGHT
	MOV	AX,(DOSV_21_UTILS SHL 8) + DOSV21_SET_MODE
	MOV	BH,BYTE PTR HEIGHT_VAL
	INT	DOSI_VIDEO
NO_SET_HEIGHT:
	RET
SET_HEIGHT	ENDP

SET_HOT_KEY	PROC	NEAR
	CMP	BYTE PTR HOT_KEY_FLAG,0
	JE	NO_SET_HOT_KEY
	MOV	DX,OFFSET HOT_KEY_MSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,(DOSV_21_UTILS SHL 8) + DOSV21_HOT_KEY
	INT	DOSI_VIDEO
S_H_K_LOOP:
	MOV	AX,(DOSV_21_UTILS SHL 8) + DOSV21_GET_MODE
	INT	DOSI_VIDEO
	OR	BL,BL
	JNZ	S_H_K_LOOP		;wait until HOT_KEY_MODE = 0
NO_SET_HOT_KEY:
	RET
SET_HOT_KEY	ENDP

MAKE_DOUBLE_FONT	PROC	NEAR
	MOV	AX,DOSV_LOAD_FONT*256 + DOSV_L_F_INFO
	MOV	BH,2			; rom 8x14 font
	INT	DOSI_VIDEO 	     ; return font info

	PUSH	DS
	MOV	CX,DS
	MOV	AX,ES
	MOV	DS,AX
	MOV	SI,BP			;DS:SI = ES:BP
	MOV	DI,OFFSET BUFFER
	MOV	ES,CX			;ES:DI = ds:BUFFER
	MOV	CX,256
M_D_LOOP1:
	PUSH	CX
	MOV	CX,14
M_D_LOOP2:
	LODSB
	STOSB
	STOSB
	LOOP	M_D_LOOP2
	POP	CX
	LOOP	M_D_LOOP1
	POP	DS
	MOV	AX,DS
	MOV	ES,AX
	MOV	BP,OFFSET BUFFER	;ES:BP => BUFFER

	MOV	AX,DOSV_LOAD_FONT*256
	MOV	BX,28*256 + 3		; bytes per char, block
	MOV	CX,256			; number of chars
	MOV	DX,0			; offset
	INT	DOSI_VIDEO 	     ; load user font
	RET

;;;;;;;;OLD TEST CODE

	MOV	AX,DOSV_LOAD_FONT*256 + DOSV_L_F_INFO
;	 MOV	 BH,2			 ; rom 8x14 font
	MOV	BH,3			; rom 8x8 font
	INT	DOSI_VIDEO 	     ; return font info
	MOV	AX,DOSV_LOAD_FONT*256
;	 MOV	 BX,14*256 + 1		  ; bytes per char, block
	MOV	BX,8*256 + 1		; bytes per char, block
	MOV	CX,256			; number of chars
	MOV	DX,0			; offset
	INT	DOSI_VIDEO 	     ; load user font
	RET
MAKE_DOUBLE_FONT	ENDP

; AX=interrupt number, DX=new offset, DI=location to save old vector

SET_VEC PROC	NEAR
	PUSH	AX
	MOV	AH,DOSF_GETIVEC
	INT	DOSI_FUNC
	MOV	[DI],BX
	MOV	[DI+2],ES
	POP	AX
	MOV	AH,DOSF_SIVEC
	INT	DOSI_FUNC
	RET
SET_VEC ENDP	    

;process command string into individual commands or options

PROCESS_COMMAND_STRING	PROC
	MOV	SI,WORD PTR COMMAND_OFFSET       ; 080H, command string
	MOV	WORD PTR COMMAND_LENGTH,0
	MOV	CL,[SI]
	MOV	CH,0		     ; CX= length(command string)
	INC	SI
	MOV	DI,OFFSET COMMAND_PTR
	CMP	CX,0
	JZ	P_C_S_DONE		    ; ret if zero length
P_C_S_NEXT_CMD:
	MOV	AL,' '
P_C_S_SPACE_LOOP:
	CMP	[SI],AL
	JNZ	P_C_S_NOT_SPACE
	INC	SI
	LOOP	P_C_S_SPACE_LOOP
	JMP	SHORT P_C_S_DONE	     ; ret

P_C_S_NOT_SPACE:
	INC	WORD PTR COMMAND_LENGTH
	MOV	[DI],SI		     ; save ptr
P_C_S_N_S_LOOP:
	CMP	[SI],AL
	JZ	P_C_S_NEXT_SPACE
	INC	SI
	LOOP	P_C_S_N_S_LOOP
P_C_S_NEXT_SPACE:
	MOV	AX,SI
	SUB	AX,[DI]
	MOV	[DI+2],AX		     ; save length in next word
	ADD	DI,4		     ; next word pair
	MOV	BYTE PTR [SI],0	     ; mark end of string
	INC	SI
	DEC	CX
	JLE	P_C_S_DONE
	CMP	WORD PTR COMMAND_LENGTH,8
	JL	P_C_S_NEXT_CMD
P_C_S_DONE:
	RET
PROCESS_COMMAND_STRING	ENDP

;search for options
;DX=option

SEARCH_FOR_OPTIONS	PROC
	MOV	DI,OFFSET COMMAND_PTR
	MOV	DX,AX
S_F_O_LOOP:
	CMP	BYTE PTR [DI+2],0	     ; command length
	JZ	S_F_O_NO_MORE
	MOV	SI,[DI]
	MOV	CX,[DI+2]
	MOV	AX,[SI]
	CMP	AL,'/'
	JNZ	S_F_O_NEXT_PAIR
	OR	AH,20H		    ; to lower
	CMP	AH,DL
	JZ	S_F_O_FOUND
S_F_O_NEXT_PAIR:
	ADD	DI,4		     ; next command pair
	JMP	SHORT	S_F_O_LOOP

S_F_O_FOUND:
	CLC
	RET

S_F_O_NO_MORE:
	STC
	RET
SEARCH_FOR_OPTIONS	ENDP


;check DOS version and EGA card

CHECK_DOS_AND_EGA	PROC	NEAR
	MOV	AH,DOSF_DOSVER
	INT	DOSI_FUNC
	CMP	AL,2
	JGE	VERSION_OK
	MOV	DX,OFFSET DOS2_MSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	INT	DOSI_TERM

VERSION_OK:
	MOV	AX,DOSV_LOAD_FONT*256 + DOSV_L_F_INFO
	MOV	CX,-1
	MOV	BH,0
	INT	DOSI_VIDEO 	     ; return font info
	CMP	CX,-1
	JNZ	EGA_OK
	MOV	DX,OFFSET EGA_MSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 1
	INT	DOSI_FUNC
	
EGA_OK:
	MOV	AH,DOSV_GET_MODE
	INT	DOSI_VIDEO
	AND	AL,07EH
	CMP	AL,2
	JE	MODE_OK
	MOV	DX,OFFSET MODE_MSG
	MOV	AH,DOSF_OUTSTR
	INT	DOSI_FUNC
	MOV	AX,DOSF_TERMPROC*256 + 2
	INT	DOSI_FUNC

MODE_OK:
	RET
CHECK_DOS_AND_EGA	ENDP

TITMSG	DB	'Magnify by B. Whitnall, V1.0',CR,LF,'$'
HLPMSG		DB	'USAGE :    MAGNIFY [/S][/D][/K][/R]',CR,LF
		DB	'  /S single height',CR,LF
		DB	'  /D double height',CR,LF
		DB	'  /K redefine hot key',CR,LF
		DB	'  /R remove from memory'
CRLFMSG		DB	CR,LF,'$'

OLDMSG	DB	'Already installed - removing old version',CR,LF,'$'
NEWMSG	DB	'Installing new version',CR,LF,'$'
REMMSG	DB	'Removing current version',CR,LF,'$'
NOMSG	DB	'No current version detected',CR,LF,'$'
EGA_MSG	DB	' MAGNIFY requires an EGA card',CR,LF,'$'
DOS2_MSG	DB	' MAGNIFY requires DOS 2+',CR,LF,'$'
MODE_MSG	DB	' MAGNIFY requires 80 column text mode',CR,LF,'$'
HOT_KEY_MSG	DB	'Enter new hot key combination : $'

COMMAND_LENGTH	DW	0
COMMAND_OFFSET	DW	0080H
COMMAND_PTR	DW	16 DUP(0)       ;8 pairs, ptr+length

REMOVE_FLAG	DB	0
HEIGHT_FLAG	DB	0
HEIGHT_VAL	DB	1
HOT_KEY_FLAG	DB	0

BUFFER:

CODE	ENDS
	END	BEGIN
